#pragma once

#include <maps/wikimap/ugc/account/src/lib/gdpr/takeout_status.h>

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/wikimap/ugc/libs/common/takeout.h>

#include <string>

namespace maps::wiki::ugc::gdpr {

std::string makeTakeoutErrorJson(
    const std::string& message,
    const std::string& code = "internal");

std::string makeTakeoutStatusResponseJson(const TakeoutStatus& takeoutStatus);

void checkCategoryId(const std::string& body);

bool createTakeoutDeleteRequest(
    pqxx::transaction_base& txn,
    Uid uid,
    const RequestId& requestId,
    TakeoutState state);

bool scheduleUserDataRemoval(
    pqxx::transaction_base& txn,
    Uid uid,
    const RequestId& requestId);

} // namespace maps::wiki::ugc::gdpr
