#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>

#include <maps/libs/chrono/include/time_point.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <pqxx/pqxx>

#include <optional>

namespace maps::wiki::ugc::gdpr {

enum class TakeoutState {
    Empty,
    ReadyToDelete,
    DeleteInProgress
};
DECLARE_ENUM_IO(TakeoutState);

struct TakeoutStatus {
    TakeoutState state;
    std::optional<maps::chrono::TimePoint> updateDate;
};

TakeoutStatus getTakeoutStatus(pqxx::transaction_base& txn, Uid uid);

} // namespace maps::wiki::ugc::gdpr
