#include <maps/wikimap/ugc/account/src/lib/globals.h>

namespace maps::wiki::ugc::account {

std::unique_ptr<Globals> Globals::create(const std::string& confPath, bool dryRun)
{
    return std::make_unique<Globals>(confPath, dryRun);
}

Globals::Globals(const std::string& confPath, bool dryRun)
    : pools(maps::json::Value::fromFile(confPath))
    , dryRun_(dryRun)
{}

} // namespace maps::wiki::ugc::account
