#pragma once

#include <maps/wikimap/ugc/libs/common/dbpools.h>

#include <memory>

namespace maps::wiki::ugc::account {

class Globals {
public:
    Globals(const std::string& confPath, bool dryRun);
    static std::unique_ptr<Globals> create(const std::string& confPath, bool dryRun);

    bool dryRun() const { return dryRun_; }

    const DbPools pools;

private:
    const bool dryRun_;
};

} // namespace maps::wiki::ugc::account
