#pragma once

#include <optional>
#include <string>

namespace maps::wiki::ugc::account {

class Paging {
public:
    Paging()
        : beforeLimit_{0}
        , afterLimit_{0}
        , baseId_{}
    {}
    Paging(
        std::optional<size_t> beforeLimit,
        std::optional<size_t> afterLimit,
        std::optional<std::string> baseId)
    : beforeLimit_{beforeLimit.value_or(0)}
    , afterLimit_{afterLimit.value_or(0)}
    , baseId_{std::move(baseId)}
    {
        // TODO: baseId basic namespace validation ?
    }

    size_t beforeLimit() const { return beforeLimit_; }
    size_t afterLimit() const { return afterLimit_; }
    std::optional<std::string> baseId() const { return baseId_; }

private:
    size_t beforeLimit_;
    size_t afterLimit_;
    std::optional<std::string> baseId_;
};

} // namespace maps::wiki::ugc::account
