#pragma once

#include <maps/wikimap/ugc/account/src/lib/paging.h>
#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/infra/yacare/include/yacare.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>

#include <set>

YCR_QUERY_PARAM(
    status,
    maps::wiki::ugc::AssignmentStatus,
    YCR_DEFAULT(maps::wiki::ugc::AssignmentStatus::Active));

template<>
struct yacare::Parser<std::set<maps::wiki::ugc::MetadataId>> {
    std::set<maps::wiki::ugc::MetadataId> operator()(const std::string& parameter) const
    try {
        std::set<maps::wiki::ugc::MetadataId> result;
        for (const std::string& token : maps::wiki::common::split(parameter, ",")) {
            result.emplace(std::stoi(token));
        }
        return result;
    } catch (const std::invalid_argument& e) {
        throw std::bad_cast();
    }
};
YCR_QUERY_PARAM(metadata_ids, std::set<maps::wiki::ugc::MetadataId>);

template<class T>
T parseOptionalArg(const yacare::Request& request, const char* name)
{
    T value;
    yacare::impl::parseArg(value, request, name, /* optional = */ true);
    return value;
}

YCR_QUERY_CUSTOM_PARAM(
    ("base_id", "before_limit", "after_limit"),
    paging,
    maps::wiki::ugc::account::Paging,
    YCR_DEFAULT(maps::wiki::ugc::account::Paging{0, 0, std::nullopt})
)
{
    auto beforeLimit = parseOptionalArg<std::optional<size_t>>(request, "before_limit");
    auto afterLimit = parseOptionalArg<std::optional<size_t>>(request, "after_limit");
    auto baseId = parseOptionalArg<std::optional<std::string>>(request, "base_id");
    if (!baseId && beforeLimit) {
        throw errors::BadRequest() << "before_limit parameter cannot be used without base_id";
    }
    dest = maps::wiki::ugc::account::Paging(beforeLimit, afterLimit, baseId);
    return true;
}

template<>
struct yacare::Parser<maps::wiki::ugc::AssignmentId> {
    maps::wiki::ugc::AssignmentId operator()(const std::string& parameter) const
    {
        return maps::wiki::ugc::AssignmentId{parameter};
    }
};
YCR_QUERY_PARAM(task_id, maps::wiki::ugc::AssignmentId);

YCR_QUERY_PARAM(request_id, std::string);
YCR_QUERY_PARAM(limit, size_t, YCR_DEFAULT(100));
