#!/bin/bash

source /usr/local/bin/tools_list.sh

errors=()
statuses="$(supervisorctl status all))"

for process in "${SUPERVISORCTL_PROCESSES[@]}"; do
    if [ "$(echo "${statuses}" | grep "${process}" | awk '{print $2}')" != "RUNNING" ]; then
        errors+=("${process} is not running")
    fi
done

if [ "${#errors[@]}" -eq "0" ]; then
    echo "0; OK"
else
    echo "2; Crit"
    for error in "${errors[@]}"; do
        echo "${error}"
    done
fi
