#pragma once

#include <maps/wikimap/ugc/libs/common/takeout.h>
#include <maps/wikimap/ugc/libs/common/types.h>

#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/libs/chrono/include/time_point.h>

#include <pqxx/pqxx>

#include <string>

namespace maps::wiki::ugc::backoffice::gdpr {

std::vector<ugc::gdpr::Takeout> loadIncompleteTakeouts(pgpool3::Pool& pool);

void setTakeoutCompleted(
    pgpool3::Pool& pool,
    const ugc::gdpr::TakeoutId& takeoutId,
    bool dryRun);

void removeTableUserData(
    pqxx::transaction_base& txn,
    const std::string& table,
    Uid uid,
    const maps::chrono::TimePoint& requestedAt);

} // namespace maps::wiki::ugc::backoffice::gdpr
