#include <maps/wikimap/ugc/backoffice/src/gdpr/lib/options.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::ugc::backoffice::gdpr {

Options parseOptions(int argc, char* argv[], const std::string& defaultConf)
{
    maps::cmdline::Parser parser;
    auto confPath = parser
        .string("config-path")
        .help("Path to custom config")
        .defaultValue(defaultConf);
    auto syslogTag = parser
        .string("syslog-tag")
        .help("Redirect log output to syslog with given tag");
    auto logLevel = parser
        .string("log-level")
        .help("log level (debug|info|warning|error|fatal)")
        .defaultValue("info");
    auto dryRun = parser
        .flag("dry-run")
        .help("do not update data in database and do not send mails and pushes")
        .defaultValue(false);
    auto statusPath = parser
        .string("status-path")
        .help("Path to status file");
    auto delay = parser
        .num("delay")
        .help("Delay between two runs in seconds, default is 30").
        defaultValue(30);
    parser.parse(argc, argv);

    log8::setLevel(logLevel);
    if (syslogTag.defined()) {
        log8::setBackend(log8::toSyslog(syslogTag));
    }

    return Options{
        confPath,
        dryRun,
        statusPath.defined()
            ? statusPath
            : std::optional<std::string>(),
        delay
    };
}

} // namespace maps::wiki::ugc::backoffice::gdpr
