#include <maps/wikimap/ugc/backoffice/src/gdpr/lib/process_takeouts.h>

#include <maps/wikimap/ugc/backoffice/src/gdpr/lib/dbqueries.h>

#include <maps/wikimap/ugc/libs/common/constants.h>
#include <maps/wikimap/ugc/libs/common/dbqueries.h>
#include <maps/wikimap/ugc/libs/common/takeout.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::ugc::backoffice::gdpr {

namespace {

void processTakeouts(pgpool3::Pool& pool, bool dryRun)
{
    auto takeouts = loadIncompleteTakeouts(pool);
    INFO() << "Loaded " << takeouts.size() << " incomplete takeouts";

    for (const auto& takeout : takeouts) {
        removeUserData(pool, takeout.uid, takeout.requestedAt, dryRun);
        setTakeoutCompleted(pool, takeout.takeoutId, dryRun);
    }
}

}

void removeUserData(
    pgpool3::Pool& pool,
    Uid uid,
    const maps::chrono::TimePoint& requestedAt,
    bool dryRun)
try {
    auto txn = pool.masterWriteableTransaction();

    removeTableUserData(*txn, tables::ASSIGNMENT, uid, requestedAt);
    removeTableUserData(*txn, tables::CONTRIBUTION, uid, requestedAt);

    finishTxn(*txn, dryRun);
} catch (const std::exception& e) {
    ERROR()
        << "Caught exception on removing data for takeout for uid "
        << uid.value() << ". Error: " << e.what();
}

void processTakeouts(const IDbPools& pools, bool dryRun)
{
    for (size_t i = 0; i < pools.size(); i++) {
        processTakeouts(pools[i], dryRun);
    }
}

} // namespace maps::wiki::ugc::backoffice::gdpr
