#include <maps/wikimap/ugc/backoffice/src/gdpr/lib/process_takeouts.h>

#include <maps/wikimap/ugc/backoffice/src/lib/links.h>

#include <maps/wikimap/ugc/libs/common/constants.h>
#include <maps/wikimap/ugc/libs/test_helpers/db_fixture.h>
#include <maps/wikimap/ugc/libs/test_helpers/test_dbpools.h>

#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/select_query.h>

#include <library/cpp/testing/unittest/env.h>
#include <library/cpp/testing/unittest/registar.h>

namespace maps::wiki::ugc::backoffice::gdpr::tests {

Y_UNIT_TEST_SUITE(test_process_takeouts)
{

Y_UNIT_TEST(remove_user_data)
{
    ugc::tests::TestDbPools db;

    Uid uid{11111};
    AssignmentId taskId{"task:1"};
    ContributionId contributionId{"contributionId:1"};
    maps::chrono::TimePoint timePoint = maps::chrono::parseIsoDateTime("2021-02-01 12:00:00+00:00");

    {
        auto txn = db.pool().masterWriteableTransaction();
        // Insert contribution and assignment before adding link
        maps::wiki::query_builder::InsertQuery(tables::CONTRIBUTION)
            .append(columns::UID, std::to_string(uid.value()))
            .appendQuoted(columns::CONTRIBUTION_ID, contributionId.value())
            .append(columns::METADATA_ID, "1")
            .appendQuoted(columns::CREATED_AT, maps::chrono::formatSqlDateTime(timePoint))
            .exec(*txn);
        maps::wiki::query_builder::InsertQuery(tables::ASSIGNMENT)
            .append(columns::UID, std::to_string(uid.value()))
            .appendQuoted(columns::TASK_ID, taskId.value())
            .appendQuoted(columns::STATUS, std::string{toString(AssignmentStatus::Active)})
            .append(columns::METADATA_ID, "3")
            .appendQuoted(columns::CREATED_AT, maps::chrono::formatSqlDateTime(timePoint))
            .exec(*txn);
        UNIT_ASSERT_NO_EXCEPTION(addLink(*txn, uid, taskId, contributionId));

        txn->commit();
    }

    {
        auto txn = db.pool().slaveTransaction();

        const auto rowsContribution = maps::wiki::query_builder::SelectQuery(tables::CONTRIBUTION).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsContribution.size(), 1);
        const auto rowsAssignment = maps::wiki::query_builder::SelectQuery(tables::ASSIGNMENT).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsAssignment.size(), 1);
        const auto rowsLinks = maps::wiki::query_builder::SelectQuery(tables::LINKS).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsLinks.size(), 1);
    }

    UNIT_ASSERT_NO_EXCEPTION(removeUserData(db.pool(), uid, timePoint, false));

    {
        auto txn = db.pool().slaveTransaction();

        const auto rowsContributionAfter = maps::wiki::query_builder::SelectQuery(tables::CONTRIBUTION).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsContributionAfter.size(), 0);
        const auto rowsAssignmentAfter = maps::wiki::query_builder::SelectQuery(tables::ASSIGNMENT).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsAssignmentAfter.size(), 0);
        const auto rowsLinksAfter = maps::wiki::query_builder::SelectQuery(tables::LINKS).exec(*txn);
        UNIT_ASSERT_VALUES_EQUAL(rowsLinksAfter.size(), 0);
    }
}

}

}
