#pragma once

#include <maps/wikimap/ugc/libs/common/dbpools.h>
#include <maps/wikimap/ugc/backoffice/src/lib/request_validator.h>
#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>
#include <yandex/maps/proto/ugc_account/backoffice.pb.h>
#include <pqxx/pqxx>

namespace maps::wiki::ugc::backoffice {

namespace proto = yandex::maps::proto::ugc_account;

void createAssignments(
    const IDbPools& pools,
    bool dryRun,
    const AssignmentId& assignmentId,
    const proto::backoffice::Task& task,
    maps::auth::TvmId tvmId,
    std::chrono::seconds ttl,
    const RequestValidator& validator);

void deleteAssignment(
    pqxx::transaction_base& txn,
    Uid uid,
    const AssignmentId& assignmentId);

void doneAssignment(
    pqxx::transaction_base& txn,
    Uid uid,
    const AssignmentId& assignmentId);

} // maps::wiki::ugc::backoffice
