#include <maps/wikimap/ugc/backoffice/src/lib/common.h>
#include <maps/wikimap/ugc/libs/common/constants.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/select_query.h>
#include <maps/infra/yacare/include/error.h>

namespace maps::wiki::ugc::backoffice {

std::optional<MetadataId> loadMetadataId(
    pqxx::transaction_base& txn,
    const std::string& table,
    const std::string& idColumn,
    const std::string& idValue)
{
    auto rows = maps::wiki::query_builder::SelectQuery(
        table,
        {columns::METADATA_ID},
        maps::wiki::query_builder::WhereConditions().appendQuoted(idColumn, idValue)
    ).limit(1).exec(txn);
    if (rows.size() == 0) {
        return std::nullopt;
    }
    return MetadataId{rows[0][columns::METADATA_ID].as<MetadataId::ValueType>()};
}

} // maps::wiki::ugc::backoffice
