#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/infra/yacare/include/error.h>
#include <pqxx/pqxx>

namespace maps::wiki::ugc::backoffice {

std::optional<MetadataId> loadMetadataId(
    pqxx::transaction_base& txn,
    const std::string& table,
    const std::string& idColumn,
    const std::string& idValue);

template <class MetadataMap, class GetMetadataId>
MetadataId getMetadataId(const MetadataMap& map, const GetMetadataId& getMetadataId)
{
    if (map.size() == 0) {
        throw yacare::errors::BadRequest() << "Empty lang_to_metadata map";
    }
    MetadataId::ValueType result = getMetadataId(map.cbegin()->second);
    for (auto it = std::next(map.cbegin()); it != map.cend(); ++it) {
        if (getMetadataId(it->second) != result) {
            throw yacare::errors::BadRequest() <<
                "Different metadata_ids found in one object";
        }
    }
    return MetadataId{result};
}

} // maps::wiki::ugc::backoffice
