#pragma once

#include <maps/wikimap/ugc/backoffice/src/lib/request_validator.h>
#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/delete_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>
#include <yandex/maps/proto/ugc_account/backoffice.pb.h>
#include <pqxx/pqxx>

namespace maps::wiki::ugc::backoffice {

namespace proto = yandex::maps::proto::ugc_account;

maps::wiki::query_builder::InsertQuery makeInsertContributionQuery(
    const ContributionId& contributionId,
    const Uid& uid,
    const MetadataId& metadataId,
    std::optional<uint64_t> timestamp);

maps::wiki::query_builder::InsertQuery makeInsertContributionDataQuery(
    const ContributionId& contributionId,
    const Uid& uid,
    const Lang& lang,
    const proto::contribution::ContributionMetadata& metadata);

void updateDb(
    pqxx::transaction_base& txn,
    const proto::backoffice::ModifyContributions& modifyContributions,
    const Uid& uid,
    maps::auth::TvmId tvmId,
    const RequestValidator& validator);

} // maps::wiki::ugc::backoffice
