#include <maps/wikimap/ugc/backoffice/src/lib/globals.h>

namespace maps::wiki::ugc::backoffice {

std::unique_ptr<Globals> Globals::create(const std::string& confPath, bool dryRun)
{
    const auto config = maps::json::Value::fromFile(confPath);
    return std::make_unique<Globals>(config, dryRun);
}

Globals::Globals(const maps::json::Value& config, bool dryRun)
    : assignmentsValidator(config["permissions"]["assignments"])
    , contributionsValidator(config["permissions"]["contributions"])
    , pools(config)
    , dryRun_(dryRun)
{}

} // namespace maps::wiki::ugc::backoffice
