#pragma once

#include <maps/wikimap/ugc/libs/common/dbpools.h>
#include <maps/wikimap/ugc/backoffice/src/lib/request_validator.h>

#include <memory>

namespace maps::wiki::ugc::backoffice {

class Globals {
public:
    Globals(const maps::json::Value& config, bool dryRun);
    static std::unique_ptr<Globals> create(const std::string& confPath, bool dryRun);

    bool dryRun() const { return dryRun_; }

    const RequestValidator assignmentsValidator;
    const RequestValidator contributionsValidator;
    const DbPools pools;

private:
    const bool dryRun_;
};

} // namespace maps::wiki::ugc::backoffice
