#include <maps/wikimap/ugc/backoffice/src/lib/links.h>
#include <maps/wikimap/ugc/libs/common/constants.h>

#include <maps/infra/yacare/include/error.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/delete_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>

namespace maps::wiki::ugc::backoffice {

namespace qb = maps::wiki::query_builder;

void addLink(
    pqxx::transaction_base& txn,
    Uid uid,
    const AssignmentId& taskId,
    const ContributionId& contributionId)
{
    try {
        qb::InsertQuery(tables::LINKS)
            .append(columns::UID, std::to_string(uid.value()))
            .appendQuoted(columns::CONTRIBUTION_ID, contributionId.value())
            .appendQuoted(columns::TASK_ID, taskId.value())
            .updateOnConflict(qb::OnConflict{})
            .exec(txn);
    } catch (const pqxx::foreign_key_violation& e) {
        WARN() << e.what();
        throw yacare::errors::NotFound()
            << "Cannot add link: unknown task_id '" << taskId
            << "' or contribution_id '" << contributionId << "' "
            << "for uid '" << uid << "'";
    }
}

void deleteLink(
    pqxx::transaction_base& txn,
    Uid uid,
    const AssignmentId& taskId,
    const ContributionId& contributionId)
{
    qb::DeleteQuery(
        tables::LINKS,
        qb::WhereConditions()
            .append(columns::UID, std::to_string(uid.value()))
            .appendQuoted(columns::CONTRIBUTION_ID, contributionId.value())
            .appendQuoted(columns::TASK_ID, taskId.value())
    ).exec(txn);
}

} // maps::wiki::ugc::backoffice

