#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/infra/yacare/include/yacare.h>

template<>
struct yacare::Parser<maps::wiki::ugc::Uid> {
    maps::wiki::ugc::Uid operator()(const std::string& parameter) const
    {
        try {
            std::size_t charsProcessed;
            const uint64_t uid = std::stoull(parameter, &charsProcessed);
            // std::stoull happily converts the strings like "11x", "4f2".
            if (charsProcessed < parameter.size()) {
                throw std::bad_cast();
            }
            return maps::wiki::ugc::Uid{uid};
        } catch (const std::invalid_argument& e) {
            throw std::bad_cast();
        }
    }
};
YCR_QUERY_PARAM(uid, maps::wiki::ugc::Uid);

template<>
struct yacare::Parser<maps::wiki::ugc::ContributionId> {
    maps::wiki::ugc::ContributionId operator()(const std::string& parameter) const
    {
        return maps::wiki::ugc::ContributionId{parameter};
    }
};
YCR_QUERY_PARAM(contribution_id, maps::wiki::ugc::ContributionId);

template<>
struct yacare::Parser<maps::wiki::ugc::AssignmentId> {
    maps::wiki::ugc::AssignmentId operator()(const std::string& parameter) const
    {
        return maps::wiki::ugc::AssignmentId{parameter};
    }
};
YCR_QUERY_PARAM(task_id, maps::wiki::ugc::AssignmentId);

YCR_QUERY_PARAM(ttl, uint64_t);
