#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/libs/auth/include/tvm.h>
#include <maps/libs/json/include/value.h>
#include <yandex/maps/proto/ugc_account/backoffice.pb.h>
#include <map>
#include <set>

namespace maps::wiki::ugc::backoffice {

namespace proto = yandex::maps::proto::ugc_account;

class RequestValidator {
public:
    explicit RequestValidator(const maps::json::Value& config);
    RequestValidator() = default;
    virtual ~RequestValidator() = default;

    virtual void checkId(maps::auth::TvmId tvmId, const std::string& id) const;
    virtual void checkMetadataId(maps::auth::TvmId tvmId, MetadataId) const;
    virtual void checkGeometry(const proto::backoffice::Task&, MetadataId) const;

private:
    std::map<maps::auth::TvmId, std::set<std::string>> allowedPrefixes_;
    std::map<maps::auth::TvmId, std::set<MetadataId>> allowedMetadatas_;
    std::set<MetadataId> requireGeometry_;
};

} // maps::wiki::ugc::backoffice
