#pragma once

#include <string>

namespace maps::wiki::ugc {

namespace tables {

const std::string ASSIGNMENT =        "ugc.assignment";
const std::string ASSIGNMENT_DATA =   "ugc.assignment_data";
const std::string CONTRIBUTION =      "ugc.contribution";
const std::string CONTRIBUTION_DATA = "ugc.contribution_data";
const std::string LINKS =             "ugc.links";
const std::string GDPR_TAKEOUT =      "gdpr.takeout";

} // namespace tables

namespace columns {

const std::string TASK_ID =         "task_id";
const std::string CONTRIBUTION_ID = "contribution_id";
const std::string UID =             "uid";
const std::string METADATA_ID =     "metadata_id";
const std::string CREATED_AT =      "created_at";
const std::string UPDATED_AT =      "updated_at";
const std::string EXPIRED_AT =      "expired_at";
const std::string POSITION =        "position";
const std::string X_COORD =         "x_coord";
const std::string Y_COORD  =        "y_coord";
const std::string STATUS =          "status";
const std::string LOCALE =          "locale";
const std::string DATA =            "data";
const std::string TAKEOUT_ID =      "takeout_id";
const std::string REQUEST_ID =      "request_id";
const std::string REQUESTED_AT =    "requested_at";
const std::string COMPLETED_AT =    "completed_at";
const std::string TTL =             "ttl";

const std::string GET_X_COORD = "ST_X(" + columns::POSITION + ") as " + X_COORD;
const std::string GET_Y_COORD = "ST_Y(" + columns::POSITION + ") as " + Y_COORD;

} // namespace columns

namespace constraints {

const std::string ASSIGNMENT      = "assignment_pkey";
const std::string ASSIGNMENT_DATA = "assignment_data_pkey";
const std::string CONTRIBUTION      = "contribution_pkey";
const std::string CONTRIBUTION_DATA = "contribution_data_pkey";

} // namespace constraints

} // namespace maps::wiki::ugc
