#include <maps/wikimap/ugc/libs/common/dbpools.h>
#include <maps/wikimap/ugc/libs/common/config.h>

namespace maps::wiki::ugc {

DbPools::DbPools(const maps::json::Value& config)
{
    const auto dbConfigs = dbConfigsFromJson(config);
    ASSERT(!dbConfigs.empty());
    for (const auto& dbConfig : dbConfigs) {
        const auto dbConfigDoc = maps::xml3::Doc::fromString(dbConfig);
        auto poolHolder = std::make_unique<maps::pgp3utils::DynamicPoolHolder>(
            dbConfigDoc.node("/database"));
        poolHolders_.emplace_back(std::move(poolHolder));
    }
}

pgpool3::Pool& DbPools::operator[](size_t index) const
{
    ASSERT(index < poolHolders_.size());
    return poolHolders_[index]->pool();
}

pgpool3::Pool& DbPools::at(Uid uid) const
{
    ASSERT(!poolHolders_.empty());
    auto index = uid.value() % poolHolders_.size();
    return poolHolders_[index]->pool();
}

} // namespace maps::wiki::ugc
