#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/libs/pgpool3utils/include/yandex/maps/pgpool3utils/dynamic_pool_holder.h>

#include <memory>

namespace maps::wiki::ugc {

class IDbPools {
public:
    virtual ~IDbPools() = default;

    virtual size_t size() const = 0;

    virtual pgpool3::Pool& operator[](size_t index) const = 0;
    virtual pgpool3::Pool& at(Uid uid) const = 0;
};

class DbPools : public IDbPools {
public:
    explicit DbPools(const maps::json::Value& config);

    size_t size() const override { return poolHolders_.size(); }

    pgpool3::Pool& operator[](size_t index) const override;
    pgpool3::Pool& at(Uid uid) const override;

private:
    std::vector<std::unique_ptr<maps::pgp3utils::DynamicPoolHolder>> poolHolders_;
};

} // namespace maps::wiki::ugc
