#include <maps/wikimap/ugc/libs/common/constants.h>
#include <maps/wikimap/ugc/libs/common/dbqueries.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/update_query.h>

namespace maps::wiki::ugc {

void finishTxn(
    pqxx::transaction_base& txn,
    bool dryRun)
{
    dryRun ? txn.abort() : txn.commit();
}

pqxx::result updateAssignmentStatus(
    pqxx::transaction_base& txn,
    Uid uid,
    AssignmentStatus status,
    const AssignmentId& assignmentId,
    maps::chrono::TimePoint timePoint)
{
    auto updateQuery = maps::wiki::query_builder::UpdateQuery(
        tables::ASSIGNMENT,
        maps::wiki::query_builder::WhereConditions()
            .append(columns::UID, std::to_string(uid.value()))
            .appendQuoted(columns::TASK_ID, assignmentId.value()));
    updateQuery
        .appendQuoted(columns::STATUS, std::string{toString(status)})
        .appendQuoted(columns::UPDATED_AT, maps::chrono::formatSqlDateTime(timePoint));
    return updateQuery.exec(txn);
}

} // namespace maps::wiki::ugc
