#include <maps/wikimap/ugc/libs/common/constants.h>
#include <maps/wikimap/ugc/libs/common/helpers.h>

namespace maps::wiki::ugc {

std::optional<geolib3::Point2> parsePoint(const pqxx::row& row)
{
    if (row[columns::POSITION].is_null()) {
        return std::nullopt;
    }
    return {geolib3::Point2{
        row[columns::X_COORD].as<double>(),
        row[columns::Y_COORD].as<double>()
    }};
}

} // namespace maps::wiki::ugc
