#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>

namespace maps::wiki::ugc::locks {

const int64_t GDPR_WORKER_DBMUTEXID = 1;
const int64_t ASSIGNMENTS_CLEANER_DBMUTEXID = 2;

const int64_t CONTRIBUTION_MODIFICATION_DBMUTEXGROUPID = 0;

// As per PostgreSQL docs, one can identify a lock
// by a single 64-bit value or two 32-bit values.
// For uids the latter option can't be employed since uids are too big,
// so we have to fall back to the 64-bit ids.
// This function is needed to avoid overlap with other processes locks.
//
// For more information refer to the PostgreSQL docs:
// https://www.postgresql.org/docs/current/functions-admin.html#FUNCTIONS-ADVISORY-LOCKS
constexpr int64_t lockIdFromUid(int64_t groupId, Uid uid) {
    return uid.value() * 1000 + groupId;
}

} // namespace maps::wiki::ugc::locks
