#include <maps/wikimap/ugc/libs/common/options.h>
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::ugc {

Options parseOptions(int argc, char* argv[], const std::string& defaultConf)
{
    maps::cmdline::Parser parser;
    auto confPath = parser
        .string("config-path")
        .help("Path to custom config")
        .defaultValue(defaultConf);
    auto logLevel = parser
        .string("log-level")
        .help("log level (debug|info|warning|error|fatal)")
        .defaultValue("info");
    auto dryRun = parser
        .flag("dry-run")
        .help("do not update data in database and do not send mails and pushes")
        .defaultValue(false);
    parser.parse(argc, argv);

    log8::setLevel(logLevel);

    return Options{
        confPath,
        dryRun
    };
}

} // namespace maps::wiki::ugc
