#include <maps/wikimap/ugc/libs/common/takeout.h>

#include <maps/wikimap/ugc/libs/common/constants.h>

#include <maps/libs/chrono/include/time_point.h>

namespace maps::wiki::ugc::gdpr {


Takeout::Takeout(const pqxx::row& row)
    : takeoutId(row[columns::TAKEOUT_ID].as<TakeoutId::ValueType>())
    , uid(row[columns::UID].as<Uid::ValueType>())
    , requestId(row[columns::REQUEST_ID].as<RequestId::ValueType>())
    , requestedAt(maps::chrono::parseSqlDateTime(
        row[columns::REQUESTED_AT].as<std::string>()))
{
    auto completedAtStr = row[columns::COMPLETED_AT]
        .as<std::optional<std::string>>();
    completedAt = completedAtStr
        ? std::optional(maps::chrono::parseSqlDateTime(*completedAtStr))
        : std::nullopt;
}

Takeout::Takeout(
    TakeoutId takeoutId,
    Uid uid,
    RequestId requestId,
    maps::chrono::TimePoint requestedAt,
    std::optional<maps::chrono::TimePoint> completedAt)
    : takeoutId(takeoutId)
    , uid(uid)
    , requestId(std::move(requestId))
    , requestedAt(std::move(requestedAt))
    , completedAt(std::move(completedAt))
{}

} // namespace maps::wiki::ugc::gdpr
