#pragma once

#include <maps/wikimap/ugc/libs/common/types.h>

#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/introspection/include/stream_output.h>
#include <maps/libs/tagged/include/tagged.h>

#include <pqxx/pqxx>

namespace maps::wiki::ugc::gdpr {

namespace tagged {

struct TakeoutId;
struct RequestId;

}  // namespace tagged

using TakeoutId = maps::tagged::Tagged<tagged::RequestId, uint64_t>;
using RequestId = maps::tagged::Tagged<tagged::RequestId, std::string>;


using maps::introspection::operator==;
using maps::introspection::operator<<;

struct Takeout {
    explicit Takeout(const pqxx::row& row);

    Takeout(
        TakeoutId takeoutId,
        Uid uid,
        RequestId requestId,
        maps::chrono::TimePoint requestedAt,
        std::optional<maps::chrono::TimePoint> completedAt);

    TakeoutId takeoutId;
    Uid uid;
    RequestId requestId;
    maps::chrono::TimePoint requestedAt;
    std::optional<maps::chrono::TimePoint> completedAt;

    auto introspect() const {
        return std::tie(
            takeoutId,
            uid,
            requestId,
            requestedAt,
            completedAt);
    }
};

} // namespace maps::wiki::ugc::gdpr
