#include <maps/wikimap/ugc/libs/common/types.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/locale/include/convert.h>

namespace maps::wiki::ugc {

constexpr maps::enum_io::Representations<AssignmentStatus> ASSIGNMENTSTATUS_REPRESENTATION {
    {AssignmentStatus::Active,  "active"},
    {AssignmentStatus::Done,    "done"},
    {AssignmentStatus::Expired, "expired"},
    {AssignmentStatus::Skipped, "skipped"}
};
DEFINE_ENUM_IO(AssignmentStatus, ASSIGNMENTSTATUS_REPRESENTATION);

Lang::Lang (std::string lang)
    : lang_{std::move(lang)}
{
    std::istringstream(lang_) >> locale_;
}

const std::string& Lang::value() const
{
    return lang_;
}

const maps::locale::Locale& Lang::locale() const
{
    return locale_;
}

} // namespace maps::wiki::ugc
