#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/libs/locale/include/locale.h>
#include <maps/libs/tagged/include/tagged.h>
#include <string>

namespace maps::wiki::ugc {

enum class AssignmentStatus {
    Active,
    Done,
    Expired,
    Skipped
};
DECLARE_ENUM_IO(AssignmentStatus);

namespace tagged {

struct Uid;
struct MetadataId;
struct ContributionId;
struct AssignmentId;

} // namespace tagged

using Uid = maps::tagged::Tagged<tagged::Uid, uint64_t>;
using MetadataId = maps::tagged::Tagged<tagged::MetadataId, int>;
using ContributionId = maps::tagged::Tagged<tagged::ContributionId, std::string>;
using AssignmentId = maps::tagged::Tagged<tagged::AssignmentId, std::string>;

class Lang {
public:
    explicit Lang(std::string);
    const maps::locale::Locale& locale() const;
    const std::string& value() const;
private:
    std::string lang_;
    maps::locale::Locale locale_;
};

} // namespace maps::wiki::ugc
