#include <maps/wikimap/ugc/libs/test_helpers/takeout.h>

#include <maps/wikimap/ugc/libs/common/constants.h>

#include <maps/wikimap/mapspro/libs/query_builder/include/insert_query.h>
#include <maps/wikimap/mapspro/libs/query_builder/include/select_query.h>

namespace maps::wiki::ugc::tests {

gdpr::TakeoutId putTakeout(
    pqxx::transaction_base& txn,
    Uid uid,
    const gdpr::RequestId& requestId,
    std::optional<maps::chrono::TimePoint> completedAt)
{
    maps::wiki::query_builder::InsertQuery query(tables::GDPR_TAKEOUT);

    query
        .append(columns::UID, std::to_string(uid.value()))
        .appendQuoted(columns::REQUEST_ID, requestId.value());

    if (completedAt) {
        query.appendQuoted(
            columns::COMPLETED_AT,
            maps::chrono::formatSqlDateTime(*completedAt));
    }

    auto queryString = query.asString(txn) + " RETURNING takeout_id";

    return gdpr::TakeoutId{txn.exec1(queryString)[0].as<gdpr::TakeoutId::ValueType>()};
}

std::vector<gdpr::Takeout> loadTakeouts(pqxx::transaction_base& txn)
{
    auto takeoutRows = query_builder::SelectQuery(
        tables::GDPR_TAKEOUT,
        query_builder::WhereConditions()).exec(txn);

    if (takeoutRows.empty()) return {};

    std::vector<gdpr::Takeout> result;
    result.reserve(takeoutRows.size());
    for (const auto& row : takeoutRows) {
        result.emplace_back(row);
    }

    return result;
}

gdpr::Takeout getTakeout(pqxx::transaction_base& txn, gdpr::TakeoutId takeoutId) {
    return gdpr::Takeout{txn.exec1(
        maps::wiki::query_builder::SelectQuery(
            tables::GDPR_TAKEOUT,
            maps::wiki::query_builder::WhereConditions()
                .append(columns::TAKEOUT_ID, std::to_string(takeoutId.value()))
        ).asString(txn))};
}

} // namespace maps::wiki::ugc::tests
