#pragma once

#include <maps/wikimap/ugc/libs/test_helpers/db_fixture.h>
#include <maps/wikimap/ugc/libs/common/dbpools.h>

namespace maps::wiki::ugc::tests {

class TestDbPools : public IDbPools {
public:
    TestDbPools() = default;

    size_t size() const override { return 1; }

    pgpool3::Pool& operator[](size_t) const override { return pool(); }
    pgpool3::Pool& at(Uid) const override { return pool(); }

    pgpool3::Pool& pool() const { return db_.pool(); }

private:
    mutable ugc::tests::DbFixture db_;
};

} // namespace maps::wiki::ugc::tests
