CREATE SCHEMA IF NOT EXISTS gdpr;

CREATE TYPE gdpr.request_status AS ENUM ('new', 'in_progress', 'completed');

CREATE TABLE gdpr.requests(
    request_id text PRIMARY KEY,
    uid bigint NOT NULL,
    status gdpr.request_status NOT NULL,
    requested_at timestamp with time zone DEFAULT CURRENT_TIMESTAMP NOT NULL,
    completed_at timestamp with time zone
);

CREATE INDEX IF NOT EXISTS requests_uid_idx ON gdpr.requests USING btree (uid);
CREATE INDEX IF NOT EXISTS requests_status_idx ON gdpr.requests USING btree (status);
