CREATE EXTENSION IF NOT EXISTS postgis;

ALTER TABLE ugc.assignment ADD position geometry(POINT, 4326);

-- btree_gist postgresql extension is necessary:
-- https://postgrespro.ru/docs/postgrespro/11/btree-gist
CREATE EXTENSION IF NOT EXISTS btree_gist;
CREATE INDEX assignment_uid_position_idx
    ON ugc.assignment
    USING gist(uid, position)
    WHERE position IS NOT NULL;
