#include <maps/wikimap/ugc/prepare_ammo/assignments/lib/prepare_ammo.h>

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>

using namespace maps::wiki::ugc;

int main(int argc, char* argv[])
try {
    maps::cmdline::Parser parser;
    auto ammoPath = parser
        .string("ammo-path")
        .help("Path output file with create assignments ammos")
        .required();
    auto ammoSize = parser
        .num("ammo-size")
        .help("Estimated ammo size")
        .defaultValue(1e6);
    parser.parse(argc, argv);

    ammo::makeAmmo(ammoPath, ammoSize);

    INFO() << "Preparing ammo is done";
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    ERROR() << "Preparing ammo failed: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    ERROR() << "Preparing ammo failed: " << e.what();
    return EXIT_FAILURE;
}
