#include <maps/wikimap/ugc/prepare_ammo/contributions/lib/prepare_ammo.h>
#include <maps/wikimap/feedback/api/src/libs/common/config.h>

#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/log8/include/log8.h>
#include <maps/libs/pgpool3utils/include/yandex/maps/pgpool3utils/dynamic_pool_holder.h>

using namespace maps::wiki::ugc;

int main(int argc, char* argv[])
try {
    maps::cmdline::Parser parser;
    auto confPath = parser
        .string("config-path")
        .help("Path to feedback-api database config.")
        .required();
    auto createPath = parser
        .string("create-path")
        .help("Path output file with create contributions ammos")
        .required();
    auto deletePath = parser
        .string("delete-path")
        .help("Path output file with create contributions ammos")
        .required();
    auto ammoOffset = parser
        .num("ammo-offset")
        .help("Expected ammo offset (ammo are sorted by feedback creation time)")
        .defaultValue(0);
    auto ammoSize = parser
        .num("ammo-size")
        .help("Estimated ammo size")
        .defaultValue(1e6);
    parser.parse(argc, argv);

    const auto config = maps::json::Value::fromFile(confPath);
    const auto dbConfig = maps::wiki::feedback::api::dbConfigFromJson(config);
    const auto dbConfigDoc = maps::xml3::Doc::fromString(dbConfig);
    maps::pgp3utils::DynamicPoolHolder poolHolder(dbConfigDoc.node("/database"));

    ammo::makeAmmo(poolHolder.pool(), createPath, deletePath, ammoOffset, ammoSize);

    INFO() << "Preparing ammo is done";
    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    ERROR() << "Preparing ammo failed: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& e) {
    ERROR() << "Preparing ammo failed: " << e.what();
    return EXIT_FAILURE;
}
