#pragma once

#include <maps/wikimap/feedback/api/src/libs/common/feedback_task.h>
#include <yandex/maps/proto/ugc_account/backoffice.pb.h>
#include <maps/libs/pgpool/include/pgpool3.h>

namespace maps::wiki::ugc::ammo {

namespace fb = maps::wiki::feedback::api;
namespace proto = yandex::maps::proto::ugc_account;

std::vector<fb::FeedbackTask> loadTasks(
    pqxx::transaction_base& txn,
    size_t offset,
    size_t limit);

proto::backoffice::ModifyContributions makeInsertContribution(
    const fb::FeedbackTask& task);
proto::backoffice::ModifyContributions makeDeleteContribution(
    const fb::FeedbackTask& task);

void writeAmmo(
    std::ofstream& out,
    const proto::backoffice::ModifyContribution&,
    uint64_t uid);

void makeAmmo(
    pgpool3::Pool& pool,
    const std::string& createAmmoPath,
    const std::string& deleteAmmoPath,
    size_t ammoOffset,
    size_t ammoSize);

} // maps::wiki::ugc::ammo
