from marshmallow import fields

from maps_adv.adv_store.api.proto import billing_pb2
from maps_adv.adv_store.api.schemas.enums import FixTimeIntervalEnum
from maps_adv.common.protomallow import (
    PbEnumField,
    PbFixedDecimalDictField,
    ProtobufSchema,
)

from .enums_map import ENUMS_MAP


class CpaSchema(ProtobufSchema):
    class Meta:
        pb_message_class = billing_pb2.Cpa

    cost = PbFixedDecimalDictField(places=4, field="value")
    budget = PbFixedDecimalDictField(
        places=4, field="value", required=False, missing=None
    )
    daily_budget = PbFixedDecimalDictField(
        places=4, field="value", required=False, missing=None
    )
    auto_daily_budget = fields.Boolean(required=False, missing=False)


class CpmSchema(ProtobufSchema):
    class Meta:
        pb_message_class = billing_pb2.Cpm

    cost = PbFixedDecimalDictField(places=4, field="value")
    budget = PbFixedDecimalDictField(
        places=4, field="value", required=False, missing=None
    )
    daily_budget = PbFixedDecimalDictField(
        places=4, field="value", required=False, missing=None
    )
    auto_daily_budget = fields.Boolean(required=False, missing=False)


class FixSchema(ProtobufSchema):
    class Meta:
        pb_message_class = billing_pb2.Fix

    time_interval = PbEnumField(
        enum=FixTimeIntervalEnum,
        pb_enum=billing_pb2.Fix.TimeIntervalEnum,
        values_map=ENUMS_MAP["time_interval"],
    )
    cost = PbFixedDecimalDictField(places=4, field="value")


class BillingSchema(ProtobufSchema):
    class Meta:
        pb_message_class = billing_pb2.Billing

    fix = fields.Nested(FixSchema, required=False)
    cpm = fields.Nested(CpmSchema, required=False)
    cpa = fields.Nested(CpaSchema, required=False)
