from enum import Enum, auto, unique

__all__ = [
    "CampaignStatusEnum",
    "FixTimeIntervalEnum",
    "ModerationResolutionEnum",
    "OrderSizeEnum",
    "PlatformEnum",
    "PublicationEnvEnum",
    "RubricEnum",
    "ReasonCampaignStoppedEnum",
    "CampaignEventTypeEnum",
    "CampaignDirectModerationStatusEnum",
    "CampaignDirectModerationWorkflowEnum",
    "ActionTypeEnum",
    "ResolveUriTargetEnum",
]


@unique
class CampaignStatusEnum(Enum):
    ACTIVE = auto()
    ARCHIVED = auto()
    DONE = auto()
    DRAFT = auto()
    PAUSED = auto()
    REJECTED = auto()
    REVIEW = auto()


@unique
class PlatformEnum(Enum):
    NAVI = auto()
    MAPS = auto()
    METRO = auto()


@unique
class ModerationResolutionEnum(Enum):
    APPROVE = auto()
    REJECT = auto()


@unique
class PublicationEnvEnum(Enum):
    PRODUCTION = auto()
    DATA_TESTING = auto()


@unique
class FixTimeIntervalEnum(Enum):
    DAILY = auto()
    WEEKLY = auto()
    MONTHLY = auto()


@unique
class RubricEnum(Enum):
    COMMON = auto()
    AUTO = auto()
    REALTY = auto()


@unique
class OrderSizeEnum(Enum):
    SMALL = auto()
    BIG = auto()
    VERY_BIG = auto()


class ReasonCampaignStoppedEnum(Enum):
    ORDER_LIMIT_REACHED = auto()
    DAILY_BUDGET_REACHED = auto()
    BUDGET_REACHED = auto()
    END_DATETIME = auto()


@unique
class CampaignEventTypeEnum(Enum):
    END_DATE_CHANGED = auto()
    STOPPED_MANUALLY = auto()
    STOPPED_BUDGET_REACHED = auto()
    BUDGET_DECREASED = auto()
    NOT_SPENDING_BUDGET = auto()


@unique
class CampaignDirectModerationStatusEnum(Enum):
    NEW = auto()
    PROCESSING = auto()
    ACCEPTED = auto()
    REJECTED = auto()
    OUTDATED = auto()


@unique
class CampaignDirectModerationWorkflowEnum(Enum):
    COMMON = auto()
    AUTO_ACCEPT = auto()
    AUTO_REJECT = auto()
    MANUAL_ONLY = auto()


@unique
class YesNoEnum(Enum):
    YES = auto()
    NO = auto()


@unique
class ActionTypeEnum(Enum):
    OPEN_SITE = auto()


@unique
class ResolveUriTargetEnum(Enum):
    WEB_VIEW = auto()
    BROWSER = auto()


@unique
class OverviewPositionEnum(Enum):
    START = auto()
    FINISH = auto()
    ALL = auto()
