from maps_adv.adv_store.api.proto.action_pb2 import ActionType, ResolveUri
from maps_adv.adv_store.api.proto.campaign_pb2 import (
    OrderSize,
    OverviewPosition,
    Platform,
    PublicationEnv,
    Rubric,
)
from maps_adv.adv_store.api.proto.campaign_status_pb2 import CampaignStatus
from maps_adv.adv_store.api.proto.charger_api_pb2 import ReasonStopped
from maps_adv.adv_store.api.proto.event_list_pb2 import CampaignEventType
from maps_adv.adv_store.api.proto.billing_pb2 import Fix
from maps_adv.adv_store.api.schemas.enums import (
    ActionTypeEnum,
    CampaignEventTypeEnum,
    CampaignStatusEnum,
    OrderSizeEnum,
    OverviewPositionEnum,
    PlatformEnum,
    PublicationEnvEnum,
    ReasonCampaignStoppedEnum,
    ResolveUriTargetEnum,
    RubricEnum,
    FixTimeIntervalEnum,
)
from maps_adv.common.helpers.enums import CampaignTypeEnum
from maps_adv.common.proto.campaign_pb2 import (
    CampaignType,
)

__all__ = ["ENUMS_MAP"]

ENUMS_MAP = {
    "platforms": [
        (Platform.NAVI, PlatformEnum.NAVI),
        (Platform.MAPS, PlatformEnum.MAPS),
        (Platform.METRO, PlatformEnum.METRO),
    ],
    "campaign_type": [
        (CampaignType.PIN_ON_ROUTE, CampaignTypeEnum.PIN_ON_ROUTE),
        (CampaignType.BILLBOARD, CampaignTypeEnum.BILLBOARD),
        (CampaignType.ZERO_SPEED_BANNER, CampaignTypeEnum.ZERO_SPEED_BANNER),
        (CampaignType.OVERVIEW_BANNER, CampaignTypeEnum.OVERVIEW_BANNER),
        (CampaignType.CATEGORY_SEARCH, CampaignTypeEnum.CATEGORY_SEARCH),
        (CampaignType.ROUTE_BANNER, CampaignTypeEnum.ROUTE_BANNER),
        (CampaignType.VIA_POINTS, CampaignTypeEnum.VIA_POINTS),
        (CampaignType.PROMOCODE, CampaignTypeEnum.PROMOCODE),
    ],
    "campaign_status": [
        (CampaignStatus.ACTIVE, CampaignStatusEnum.ACTIVE),
        (CampaignStatus.ARCHIVED, CampaignStatusEnum.ARCHIVED),
        (CampaignStatus.DONE, CampaignStatusEnum.DONE),
        (CampaignStatus.DRAFT, CampaignStatusEnum.DRAFT),
        (CampaignStatus.PAUSED, CampaignStatusEnum.PAUSED),
        (CampaignStatus.REJECTED, CampaignStatusEnum.REJECTED),
        (CampaignStatus.REVIEW, CampaignStatusEnum.REVIEW),
    ],
    "publication_env": [
        (PublicationEnv.PRODUCTION, PublicationEnvEnum.PRODUCTION),
        (PublicationEnv.DATA_TESTING, PublicationEnvEnum.DATA_TESTING),
    ],
    "rubric": [
        (Rubric.AUTO, RubricEnum.AUTO),
        (Rubric.COMMON, RubricEnum.COMMON),
        (Rubric.REALTY, RubricEnum.REALTY),
    ],
    "order_size": [
        (OrderSize.SMALL, OrderSizeEnum.SMALL),
        (OrderSize.BIG, OrderSizeEnum.BIG),
        (OrderSize.VERY_BIG, OrderSizeEnum.VERY_BIG),
    ],
    "reason_stopped": [
        (
            ReasonStopped.ORDER_LIMIT_REACHED,
            ReasonCampaignStoppedEnum.ORDER_LIMIT_REACHED,
        ),
        (
            ReasonStopped.DAILY_BUDGET_REACHED,
            ReasonCampaignStoppedEnum.DAILY_BUDGET_REACHED,
        ),
        (ReasonStopped.BUDGET_REACHED, ReasonCampaignStoppedEnum.BUDGET_REACHED),
    ],
    "campaign_event_type": [
        (CampaignEventType.END_DATE_CHANGED, CampaignEventTypeEnum.END_DATE_CHANGED),
        (CampaignEventType.STOPPED_MANUALLY, CampaignEventTypeEnum.STOPPED_MANUALLY),
        (
            CampaignEventType.STOPPED_BUDGET_REACHED,
            CampaignEventTypeEnum.STOPPED_BUDGET_REACHED,
        ),
        (CampaignEventType.BUDGET_DECREASED, CampaignEventTypeEnum.BUDGET_DECREASED),
        (
            CampaignEventType.NOT_SPENDING_BUDGET,
            CampaignEventTypeEnum.NOT_SPENDING_BUDGET,
        ),
    ],
    "action_type": [(ActionType.OPEN_SITE, ActionTypeEnum.OPEN_SITE)],
    "resolve_uri_target": [
        (ResolveUri.Target.WEB_VIEW, ResolveUriTargetEnum.WEB_VIEW),
        (ResolveUri.Target.BROWSER, ResolveUriTargetEnum.BROWSER),
    ],
    "overview_position": [
        (OverviewPosition.Enum.START, OverviewPositionEnum.START),
        (OverviewPosition.Enum.FINISH, OverviewPositionEnum.FINISH),
        (OverviewPosition.Enum.ALL, OverviewPositionEnum.ALL),
    ],
    "time_interval": [
        (Fix.TimeIntervalEnum.Value("DAILY"), FixTimeIntervalEnum.DAILY),
        (Fix.TimeIntervalEnum.Value("WEEKLY"), FixTimeIntervalEnum.WEEKLY),
        (
            Fix.TimeIntervalEnum.Value("MONTHLY"),
            FixTimeIntervalEnum.MONTHLY,
        ),
    ],
}
