from marshmallow import fields

from maps_adv.adv_store.api.proto import event_list_pb2
from maps_adv.adv_store.api.schemas.enums import CampaignEventTypeEnum
from maps_adv.common.protomallow import PbDateTimeField, PbEnumField, ProtobufSchema

from .enums_map import ENUMS_MAP


class TimeRangeFilterSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.TimeRangeFilter

    from_timestamp = PbDateTimeField(required=False)
    to_timestamp = PbDateTimeField(required=False)


class CampaignEventForOrderIdsInputSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.CampaignEventForOrderIdsInput

    order_ids = fields.List(fields.Integer())
    manul_order_ids = fields.List(fields.Integer())
    time_range = fields.Nested(TimeRangeFilterSchema)
    starting_event_id = fields.Integer(required=False)
    limit = fields.Integer(required=False)


class CampaignEventSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.CampaignEventListItem

    id = fields.Integer()
    timestamp = PbDateTimeField()
    campaign_id = fields.Integer()
    campaign_name = fields.String()
    billing_order_id = fields.Integer(required=False)
    manul_order_id = fields.Integer(required=False)
    event_type = PbEnumField(
        enum=CampaignEventTypeEnum,
        pb_enum=event_list_pb2.CampaignEventType.Enum,
        values_map=ENUMS_MAP["campaign_event_type"],
    )


class CampaignEventListSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.CampaignEventList

    events = fields.List(fields.Nested(CampaignEventSchema))


class CampaignEventDataSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.CampaignEventData

    timestamp = PbDateTimeField()
    campaign_id = fields.Integer()
    event_type = PbEnumField(
        enum=CampaignEventTypeEnum,
        pb_enum=event_list_pb2.CampaignEventType.Enum,
        values_map=ENUMS_MAP["campaign_event_type"],
    )


class CampaignEventDataListSchema(ProtobufSchema):
    class Meta:
        pb_message_class = event_list_pb2.CampaignEventDataList

    events = fields.List(fields.Nested(CampaignEventDataSchema))
