from marshmallow import fields

from maps_adv.adv_store.api.proto import placing_pb2
from maps_adv.common.protomallow import ProtobufSchema


class PointSchema(ProtobufSchema):
    class Meta:
        pb_message_class = placing_pb2.Point

    lon = fields.Float()
    lat = fields.Float()


class PolygonSchema(ProtobufSchema):
    class Meta:
        pb_message_class = placing_pb2.Polygon

    points = fields.Nested(PointSchema, many=True)
    name = fields.String(required=True)
    preset_id = fields.String(required=False, missing=None)


class OrganizationsSchema(ProtobufSchema):
    class Meta:
        pb_message_class = placing_pb2.Organizations

    permalinks = fields.List(fields.Integer())


class AreaSchema(ProtobufSchema):
    class Meta:
        pb_message_class = placing_pb2.Area

    version = fields.Integer()
    areas = fields.Nested(PolygonSchema, many=True)


class PlacingSchema(ProtobufSchema):
    class Meta:
        pb_message_class = placing_pb2.Placing

    area = fields.Nested(AreaSchema, required=False)
    organizations = fields.Nested(OrganizationsSchema, required=False)
