import argparse
import asyncio
import logging

from aiohttp import web

from maps_adv.adv_store.lib import Application

parser = argparse.ArgumentParser("Adv store http server")
parser.add_argument("--host")
parser.add_argument("--port")
parser.add_argument("--config")


def main():
    logging.basicConfig(level=logging.DEBUG)
    args = parser.parse_args()

    app = Application()
    asyncio.get_event_loop().run_until_complete(app.setup(args.config))

    web.run_app(app.api, host=args.host, port=args.port, loop=asyncio.get_event_loop())


if __name__ == "__main__":
    main()
