from aiohttp import web

from . import middlewares
from .resources import campaign, system


def create():
    app = web.Application(
        middlewares=[
            middlewares.handle_domain_exception,
            middlewares.handle_validation_exception,
        ]
    )
    app.add_routes(
        [
            web.get(r"/ping", system.ping),
            web.get(
                r"/campaign/{campaign_id:\d+}/status_history/",
                campaign.get_status_history,
            ),
        ]
    )
    return app
