from maps_adv.adv_store.lib.domain.exceptions import (
    ActionSearchOrganizationsAreEmpty,
    CampaignCreativesAreEmpty,
    CampaignNotFound,
    CampaignNotInReview,
    CreatvieImagesAreEmpty,
    DomainException,
    InvalidCampaignName,
    InvalidPlacing,
    InvalidTimezoneName,
    InvalidWeekSchedule,
    MoneyQuantityNotPositive,
    PlacingAreaPolygonIsEmpty,
    PlacingAreasAreEmpty,
    PlacingPermalinksAreEmpty,
    PlatformsAreEmpty,
    PublicationEnvsAreEmpty,
    ReviewCommentEmpty,
    ShowingPeriodStartLaterThanEnd,
    TargetingDoesNotMatchSchema,
    WrongSetOfCreativesForTheCampaignType,
)
from maps_adv.adv_store.api.proto import error_pb2

EXCEPTION_ERROR_CODES = {
    ShowingPeriodStartLaterThanEnd: error_pb2.Error.SHOWING_PERIOD_START_LATER_THAN_END,
    TargetingDoesNotMatchSchema: error_pb2.Error.TARGETING_DOES_NOT_MATCH_SCHEMA,
    InvalidWeekSchedule: error_pb2.Error.INVALID_WEEK_SCHEDULE,
    WrongSetOfCreativesForTheCampaignType: error_pb2.Error.WRONG_SET_OF_CREATIVES_FOR_THE_CAMPAIGN_TYPE,  # noqa: E501
    MoneyQuantityNotPositive: error_pb2.Error.MONEY_QUANTITY_NOT_POSITIVE,
    InvalidTimezoneName: error_pb2.Error.INVALID_TIMEZONE_NAME,
    InvalidCampaignName: error_pb2.Error.INVALID_CAMPAIGN_NAME,
    PublicationEnvsAreEmpty: error_pb2.Error.PUBLICATION_ENVS_ARE_EMPTY,
    PlatformsAreEmpty: error_pb2.Error.PLATFORMS_ARE_EMPTY,
    PlacingPermalinksAreEmpty: error_pb2.Error.PLACING_PERMALINKS_ARE_EMPTY,
    PlacingAreasAreEmpty: error_pb2.Error.PLACING_AREAS_ARE_EMPTY,
    PlacingAreaPolygonIsEmpty: error_pb2.Error.PLACING_AREA_POLYGON_IS_EMPTY,
    CreatvieImagesAreEmpty: error_pb2.Error.CREATIVE_IMAGES_ARE_EMPTY,
    CampaignCreativesAreEmpty: error_pb2.Error.CAMPAIGN_CREATIVES_ARE_EMPTY,
    ActionSearchOrganizationsAreEmpty: error_pb2.Error.ACTION_SEARCH_ORGANIZATIONS_ARE_EMPTY,  # noqa: E501
    InvalidPlacing: error_pb2.Error.INVALID_PLACING,
    CampaignNotFound: error_pb2.Error.CAMPAIGN_NOT_FOUND,
    CampaignNotInReview: error_pb2.Error.CAMPAIGN_NOT_IN_REVIEW,
    ReviewCommentEmpty: error_pb2.Error.REVIEW_COMMENT_EMPTY,
}


__all__ = [
    "DomainException",
    "ShowingPeriodStartLaterThanEnd",
    "TargetingDoesNotMatchSchema",
    "InvalidWeekSchedule",
    "WrongSetOfCreativesForTheCampaignType",
    "MoneyQuantityNotPositive",
    "InvalidTimezoneName",
    "InvalidCampaignName",
    "PublicationEnvsAreEmpty",
    "PlatformsAreEmpty",
    "PlacingPermalinksAreEmpty",
    "PlacingAreasAreEmpty",
    "PlacingAreaPolygonIsEmpty",
    "CreatvieImagesAreEmpty",
    "CampaignCreativesAreEmpty",
    "ActionSearchOrganizationsAreEmpty",
    "InvalidPlacing",
    "CampaignNotFound",
    "CampaignNotInReview",
    "ReviewCommentEmpty",
    "EXCEPTION_ERROR_CODES",
]
