from maps_adv.config_loader import Config

_config = {
    "DATABASE_URI": {},
    "DATABASE_URI_RO": {"default": None},
    "BILLING_API_URL": {"default": "http://localhost/"},
    "WARDEN_API_URL": {"default": "http://localhost/"},
    "TASKS_TO_START": {
        "default": [
            "StopCampaignsDateEnd",
            "RefreshDisplayProbabilityForCampaigns",
        ],
        "converter": lambda data: [el.strip() for el in data.split(",") if el.strip()],
    },
    "TASK_RELAUNCH_INTERVAL": {"default": 30, "converter": int},
    # YQL
    "YQL_TOKEN": {"default": None},
    "YQL_CLUSTER": {"default": "hahn"},
    "YQL_DISPLAY_PROBABILITY_TABLE": {
        "default": "home/geodisplay/analytics/regular/campaigns_probability/campaign_limit_probability"  # noqa: E501
    },
    # Experiments
    # TODO(megadiablo) Выкинуть флаг после завершения эксперемента
    #                  GEOADVDEV-2493
    "EXPERIMENT_CALCULATE_DISPLAY_CHANCE_FROM_CPM": {
        "default": False,
        "converter": bool,
    },
}


config = Config(_config)
