from typing import List

from maps_adv.adv_store.lib.data_managers.campaign_display_probability import (
    retrieve_campaigns_display_probability,
    update_campaign_display_probability,
)
from maps_adv.adv_store.lib.data_managers.common import does_campaign_exist
from maps_adv.adv_store.lib.data_managers.status_history import (
    get_campaign_status_history as get_campaign_status_history_dm,
)

from .exceptions import CampaignNotFound


def _filter_campaigns_empty_fields(campaigns: List[dict]) -> List[dict]:
    return [
        {k: v for k, v in campaign.items() if v is not None} for campaign in campaigns
    ]


async def get_campaign_status_history(campaign_id):
    if not await does_campaign_exist(campaign_id):
        raise CampaignNotFound

    history = await get_campaign_status_history_dm(campaign_id)
    return history


async def refresh_campaigns_display_probability():
    data = await retrieve_campaigns_display_probability()
    for campaign_id, new_display_probability in data.items():
        await update_campaign_display_probability(campaign_id, new_display_probability)
