import urllib.parse
from datetime import datetime, timezone

import aiohttp

from maps_adv.adv_store.lib.config import config
from maps_adv.adv_store.lib.data_managers.unstop_campaigns import (
    stop_campaigns_date_end as stop_campaigns_date_end_dm,
)
from maps_adv.billing_proxy.proto.orders_pb2 import OrderIds


async def stop_campaigns_date_end():
    await stop_campaigns_date_end_dm(datetime.now(tz=timezone.utc))


async def _get_active_order_ids():
    async with aiohttp.ClientSession() as session:
        async with session.post(
            urllib.parse.urljoin(config.BILLING_API_URL, "/orders/active/")
        ) as response:
            resp_proto = OrderIds.FromString(await response.read())

    return set(resp_proto.order_ids)
