from . import exceptions

ACTION_TYPES = {"open_site", "search", "phone_call", "download_app"}

CREATIVE_TYPES = {
    "billboard",
    "logo_and_text",
    "banner",
    "pin",
    "icon",
    "pin_search",
    "text",
    "via_point",
}

TARGETING_SCHEMA = {
    "$schema": "http://json-schema.org/draft-06/schema#",
    "$ref": "#/definitions/target",
    "definitions": {
        "target": {
            "type": "object",
            "oneOf": [
                {"$ref": "#/definitions/targetContent"},
                {"$ref": "#/definitions/targetArray"},
                {"$ref": "#/definitions/targetAttributes"},
                {"$ref": "#/definitions/targetEmpty"},
            ],
        },
        "targetContent": {
            "required": ["tag", "content"],
            "oneOf": [
                {
                    "properties": {
                        "tag": {"enum": ["age"]},
                        "content": {
                            "oneOf": [
                                {"$ref": "#/definitions/enumAge"},
                                {
                                    "type": "array",
                                    "minItems": 1,
                                    "items": {"$ref": "#/definitions/enumAge"},
                                },
                            ]
                        },
                    }
                },
                {
                    "properties": {
                        "tag": {"enum": ["gender"]},
                        "content": {
                            "oneOf": [
                                {"$ref": "#/definitions/enumGender"},
                                {
                                    "type": "array",
                                    "minItems": 1,
                                    "items": {"$ref": "#/definitions/enumGender"},
                                },
                            ]
                        },
                    }
                },
                {
                    "properties": {
                        "tag": {"enum": ["income"]},
                        "content": {
                            "oneOf": [
                                {"$ref": "#/definitions/enumIncome"},
                                {
                                    "type": "array",
                                    "minItems": 1,
                                    "items": {"$ref": "#/definitions/enumIncome"},
                                },
                            ]
                        },
                    }
                },
            ],
        },
        "targetArray": {
            "required": ["tag", "items"],
            "properties": {
                "tag": {"enum": ["and", "or"]},
                "items": {"type": "array", "items": {"$ref": "#/definitions/target"}},
            },
        },
        "targetAttributes": {
            "required": ["tag", "attributes"],
            "oneOf": [
                {
                    "properties": {
                        "tag": {"enum": ["segment"]},
                        "attributes": {
                            "type": "object",
                            "required": ["id", "keywordId"],
                            "properties": {
                                "id": {"type": "string"},
                                "keywordId": {"type": "string"},
                            },
                        },
                    }
                },
                {
                    "properties": {
                        "tag": {"enum": ["audience"]},
                        "attributes": {
                            "type": "object",
                            "required": ["id"],
                            "properties": {"id": {"type": "string"}},
                        },
                    }
                },
            ],
        },
        "targetEmpty": {
            "type": "object",
            "properties": {},
            "additionalProperties": False,
        },
        "enumAge": {"enum": ["18-", "18-24", "25-34", "35-44", "45-54", "55+"]},
        "enumGender": {"enum": ["male", "female"]},
        "enumIncome": {"enum": ["low", "middle", "high"]},
    },
}


def validate_placing_permalinks_not_empty(placing):
    if len(placing["organizations"]["permalinks"]) == 0:
        raise exceptions.PlacingPermalinksAreEmpty


def validate_placing_areas_not_empty(placing):
    if len(placing["area"]["areas"]) == 0:
        raise exceptions.PlacingAreasAreEmpty


def validate_area_polygon_not_empty(placing):
    empty = [len(a["points"]) == 0 for a in placing["area"]["areas"]]
    if any(empty):
        raise exceptions.PlacingAreaPolygonIsEmpty
